/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.SoundProxy;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Component;

public class InsertBlockAction
extends UndoableAction {
    public Figure insertedFigure;

    public InsertBlockAction() {
        this.putValue("ShortDescription", Language.getStringNoTilde("pdraw.standard.creation", "Creation"));
    }

    public boolean doIt() {
        LogoDrawing drawing = (LogoDrawing)((LogoComfort)this.getOwner()).view().drawing();
        this.insertedFigure.getConstraint().insert(drawing);
        super.doIt();
        if (Global.fun) {
            SoundProxy.getInstance().getClip("TransferOk.au").play();
        }
        return true;
    }

    public boolean prepareAction() {
        LogoDrawingView view = (LogoDrawingView)((LogoComfort)this.getOwner()).view();
        this.insertedFigure.getConstraint().doMove(view.getSnapVector(this.insertedFigure));
        if (this.insertedFigure instanceof UDFBlockFigure) {
            UDFBlock editUDF;
            String identifier;
            int[] freeResources;
            UDFBlock block = (UDFBlock)((UDFBlockFigure)this.insertedFigure).getBlock();
            boolean existFlag = false;
            for (GuidVersionMgr usedGuid : ((LogoDrawing)view.drawing()).getWiringDiagram().getUsedUDFGuids()) {
                if (usedGuid.compareTo(block.getGuidManager()) == 2) continue;
                existFlag = true;
                break;
            }
            if (!existFlag && (freeResources = ((LogoDrawing)view.drawing()).getWiringDiagram().getFreeResources())[24] < 1) {
                identifier = ((UDFBlock)((UDFBlockFigure)this.insertedFigure).getBlock()).getIdentifier();
                int maxTypeNum = ((LogoDrawing)view.drawing()).getWiringDiagram().getHardware().getMaxResources()[24];
                Object[] params = new String[]{String.valueOf(maxTypeNum), identifier};
                LogoError error = new LogoError((Component)this.getOwner().getWindow(), "msg.insertUDFTypeOver", "Failed to insert: the number of UDF types would exceed " + maxTypeNum + " in the current program after insertion [" + identifier + "].", params, 0, 0);
                error.display();
                return false;
            }
            if (!block.isResourceAvailable(((LogoDrawing)view.drawing()).getWiringDiagram()) || !block.isResourceAvailable4Children(((LogoDrawing)view.drawing()).getWiringDiagram())) {
                String identifier2 = ((UDFBlock)((UDFBlockFigure)this.insertedFigure).getBlock()).getIdentifier();
                Object[] params = new String[]{identifier2};
                LogoError error = new LogoError((Component)this.getOwner().getWindow(), "msg.noresourcesudf", "Insufficient resources for UDFBlock: " + identifier2, params, 0, 0);
                error.display();
                return false;
            }
            if (view instanceof LogoDrawingViewUDF && (editUDF = ((WiringDiagramUDF)((LogoDrawing)view.drawing()).getWiringDiagram()).getUDFBlock()).isUDFSelf(((UDFBlockFigure)this.insertedFigure).getBlock())) {
                identifier = ((UDFBlock)((UDFBlockFigure)this.insertedFigure).getBlock()).getIdentifier();
                Object[] params = new String[]{identifier};
                LogoError error = new LogoError((Component)this.getOwner().getWindow(), "msg.insertUDFSelf", "Failed to insert: " + identifier + "or its child is already in the current program.", params, 0, 0);
                error.display();
                return false;
            }
            block.handleChildBlockNumbers(((LogoDrawing)view.drawing()).getWiringDiagram(), true);
        }
        return true;
    }

    public void setBlockFigure(Figure blockFigure) {
        this.insertedFigure = blockFigure;
    }

    public String toString() {
        return super.toString() + ": " + this.insertedFigure;
    }

    public void undoIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        view.clearSelection();
        this.insertedFigure.getConstraint().delete();
        view.checkDamage();
    }
}

